<?php

/**
 * @file
 * Default simple view template to display a list of summary lines.
 *
 * @ingroup views_templates
 */
 global $language;
?>

<div id="filters" class="item-list button-group">
    <ul class="views-summary">
        <li>
            <a id="show-all" class="is-checked" data-filter="*" data-category="<?php print t('all'); ?>">
                <?php print t('all'); ?>
            </a>
        </li>
        <?php foreach ($rows as $id => $row): ?>
        	<?php
        		// Fix: Taxonomy Term Name is not Translated as contextual filter
        		if ($language->language === 'es' && $row->link === 'Hoteis') {
        			$row->link = 'Hoteles';
        		}
        	?>
            <li>
                <a class="toggle-category" data-filter=".<?php print $row->link; ?>"
                   data-category="<?php print strtolower($row->link); ?>">
                    <?php print $row->link; ?>
                </a>
                <?php if (!empty($options['count'])): ?>
                    [<?php print $row->count; ?>]
                <?php endif; ?>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
