<?php
/**
 * @file
 * Default theme implementation to display a node.
 *
 * Available variables:
 * - $title: the (sanitized) title of the node.
 * - $content: An array of node items. Use render($content) to print them all,
 *   or print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $user_picture: The node author's picture from user-picture.tpl.php.
 * - $date: Formatted creation date. Preprocess functions can reformat it by
 *   calling format_date() with the desired parameters on the $created variable.
 * - $name: Themed username of node author output from theme_username().
 * - $node_url: Direct URL of the current node.
 * - $display_submitted: Whether submission information should be displayed.
 * - $submitted: Submission information created from $name and $date during
 *   template_preprocess_node().
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default values can be one or more of the
 *   following:
 *   - node: The current template type; for example, "theming hook".
 *   - node-[type]: The current node type. For example, if the node is a
 *     "Blog entry" it would result in "node-blog". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - node-teaser: Nodes in teaser form.
 *   - node-preview: Nodes in preview mode.
 *   The following are controlled through the node publishing options.
 *   - node-promoted: Nodes promoted to the front page.
 *   - node-sticky: Nodes ordered above other non-sticky nodes in teaser
 *     listings.
 *   - node-unpublished: Unpublished nodes visible only to administrators.
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * Other variables:
 * - $node: Full node object. Contains data that may not be safe.
 * - $type: Node type; for example, story, page, blog, etc.
 * - $comment_count: Number of comments attached to the node.
 * - $uid: User ID of the node author.
 * - $created: Time the node was published formatted in Unix timestamp.
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 * - $zebra: Outputs either "even" or "odd". Useful for zebra striping in
 *   teaser listings.
 * - $id: Position of the node. Increments each time it's output.
 *
 * Node status variables:
 * - $view_mode: View mode; for example, "full", "teaser".
 * - $teaser: Flag for the teaser state (shortcut for $view_mode == 'teaser').
 * - $page: Flag for the full page state.
 * - $promote: Flag for front page promotion state.
 * - $sticky: Flags for sticky post setting.
 * - $status: Flag for published status.
 * - $comment: State of comment settings for the node.
 * - $readmore: Flags true if the teaser content of the node cannot hold the
 *   main body content.
 * - $is_front: Flags true when presented in the front page.
 * - $logged_in: Flags true when the current user is a logged-in member.
 * - $is_admin: Flags true when the current user is an administrator.
 *
 * Field variables: for each field instance attached to the node a corresponding
 * variable is defined; for example, $node->body becomes $body. When needing to
 * access a field's raw values, developers/themers are strongly encouraged to
 * use these variables. Otherwise they will have to explicitly specify the
 * desired field language; for example, $node->body['en'], thus overriding any
 * language negotiation rule that was previously applied.
 *
 * @see template_preprocess()
 * @see template_preprocess_node()
 * @see template_process()
 *
 * @ingroup templates
 */
 global $language;
?>
<article id="node-<?php print $node->nid; ?>" class="<?php print $classes; ?> clearfix"<?php print $attributes; ?>>
    <?php
    // Hide comments, tags, and links now so that we can render them later.
    hide($content['comments']);
    hide($content['links']);
    hide($content['field_tags']);

    //    print '<pre>';
    //    print_r($field_loc);
    //    print '</pre>';
	
	if ($language->language === 'es' && trim(render($content['field_type_map'])) === 'Hoteis') {
		$content['field_type_map'] = 'Hoteles';
	}
    ?>

    <div class="map-item" data-id="map-item-<?php print render($field_loc['0']['lid']); ?>"
         data-latitude="<?php print render($field_loc['0']['latitude']); ?>"
         data-longitude="<?php print render($field_loc['0']['longitude']); ?>"
         data-name="<?php print render($field_loc['0']['name']); ?>"
         data-category="<?php print trim(render($content['field_type_map'])); ?>">
        <div class="row">
            <div class="col-sm-9">
                <!-- Title -->
                <?php if (!empty($title)): ?>
                    <header>
                        <h1 class="title">
                            <?php print $title; ?>
                        </h1>
                    </header>
                <?php endif; ?>

                <!-- SubTitle -->
                <?php if (!empty($content['field_subtitle'])): ?>
                    <div class="subtitle">
                        <?php print render($content['field_subtitle']); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-sm-3">
                <div class="map-extras">
                    <span class="rate"><?php print $node->rate_place_rating['#markup']; ?></span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <!-- Image -->
                <?php if (!empty($content['field_image'])): ?>
                    <div class="image">
                        <?php print render($content['field_image']); ?>
                    </div>
                <?php endif; ?>

                <!-- Video -->
                <?php if (!empty($content['field_video'])): ?>
                    <div class=" video embed-responsive embed-responsive-16by9">
                        <?php print render($content['field_video']); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-8 col-md-9">
                <!-- Body -->
                <?php if (!empty($content['body'])): ?>
                    <div class="body">
                        <?php print render($content['body']); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-sm-4 col-md-3">
                <aside class="node-aside">
                    <!-- Social -->
                    <div class="share">
                        <div class="row">
                            <div class="col-xs-6">
                                <?php print $service_links_rendered; ?>
                            </div>
                            <div class="col-xs-6">
                                <div class="feedback">
                                    <?php
                                    $block = module_invoke('block', 'block_view', '4');
                                    print render($block['content']);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Links -->
                    <?php if (!empty($content['field_links'])): ?>
                        <div class="links">
                            <div class="label">
                                <?php print render($content['field_links']['#title']); ?>
                            </div>
                            <?php print render($content['field_links']); ?>
                        </div>
                    <?php endif; ?>
                    <!-- Downloads -->
                    <?php if (!empty($content['field_downloads'])): ?>
                        <div class="downloads">
                            <div class="label">
                                <?php print render($content['field_downloads']['#title']); ?>
                            </div>
                            <?php print render($content['field_downloads']); ?>
                        </div>
                    <?php endif; ?>
                </aside>
            </div>
        </div>
    </div>

</article>
