<?php
/**
 * @file
 * The primary PHP file for this theme.
 */

// Calling page specific, custom html.tpl.php template
function tm_preprocess_html(&$variables)
{
	$path = drupal_get_path_alias();
	$aliases = explode('/', $path);
	foreach($aliases as $alias) {
		$variables['classes_array'][] = 'page-' . drupal_clean_css_identifier($alias);
	}
}

// Add map.js to Map view
function tm_preprocess_page(&$variables, $hook)
{
    // Load easing library
    libraries_load('easing');

    // Page node type template
    if (!empty($variables['node']) && !empty($variables['node']->type)) {
        $variables['theme_hook_suggestions'][] = 'page__node__' . $variables['node']->type;
        // Page--mapa.tpl.php
        if ($variables['node']->type === 'place') {
            $variables['theme_hook_suggestions'][] = 'page__mapa';
        }
    }

    // Print node fields in page.tpl.php
    if (arg(0) == 'node') {
        $variables['node_content'] = &$variables['page']['content']['system_main']['nodes'][arg(1)];
    }

    // All pages
    drupal_add_js('https://use.typekit.net/xbl5puj.js', 'external');
    drupal_add_js('try{Typekit.load({ async: true });}catch(e){}', 'inline');

    // Map
    if ('mapa' === arg(0) || (!empty($variables['node']) && !empty($variables['node']->type) && $variables['node']->type === 'place')) {
        drupal_add_js(path_to_theme() . '/js/map.js', array(
            'scope' => 'footer',
            'preprocess' => FALSE,
            'cache' => FALSE
        ));
        drupal_add_js('https://maps.googleapis.com/maps/api/js?key=AIzaSyCNemw9ccXj3VQAHlmVGLaj5yFQnhQRmFQ&callback=initMap', array(
            'scope' => 'footer',
            // 'async' => TRUE,
            'defer' => TRUE,
            'preprocess' => FALSE,
            'cache' => FALSE
        ));
        if ('mapa' === arg(0)) {
            drupal_add_js('sites/all/libraries/isotope/isotope.pkgd.min.js', array(
                'scope' => 'footer'
            ));
            drupal_add_js(path_to_theme() . '/js/isotope.js', array(
                'scope' => 'footer'
            ));
        }
    }
    
        // Activities
    if ('actividades' === arg(0) || (!empty($variables['node']) && !empty($variables['node']->type) && $variables['node']->type === 'activity')) {
        drupal_add_js('sites/all/libraries/jquery_touch_swipe/jquery.touchSwipe.min.js', array(
            'scope' => 'footer'
        ));
    }
    
    $variables['scripts'] = drupal_get_js();
}

// Language Block
function tm_language_switch_links_alter(array &$links, $type, $path)
{
    foreach ($links as $key => $link) {
        // Hide untranslated languages
        if (isset($link['attributes']['class']) && in_array('locale-untranslated', $link['attributes']['class'])) {
            unset($links[$key]);
        } else {
            // 3-letters language names
            $links[$key]['title'] = substr(strtoupper($link['language']->native), 0, 3);
        }
    }
}

// Filters duplicated results in views page due to a multi-valued field (Field category)
// http://drupal.stackexchange.com/questions/39280/results-in-view-page-having-multiple-duplicate-result
function tm_views_pre_render(&$view)
{
    $used_nids = array();
    $new_view_result = array();

    if ($view->name == 'archives' || $view->name == 'activities' || $view->name == 'taxonomy_term') {
        foreach ($view->result as $row) {
            if (!in_array($row->nid, $used_nids)) {
                $new_view_result[] = $row;
                $used_nids[] = $row->nid;
            }
        }
        $view->result = $new_view_result;
    }
}

/**
 * Preprocess function for the fivestar template.
 */
function tm_preprocess_rate_template_fivestar(&$variables)
{
    extract($variables);

    // print '<pre>';
    // print_r($results);
    // print '</pre>';

    $stars = array();
    $count = count($links);
    $percent_per_star = 100 / ($count - 1);
    for ($i = 0; $i < $count; $i++) {
        // if (round($results['rating'] / $percent_per_star) >= $i && !$results['empty']) {
        if ($results['rating'] / $percent_per_star >= $i && !$results['empty']) {
            $class = 'rate-fivestar-btn-filled';
        } else {
            $class = 'rate-fivestar-btn-empty';
        }
        $class .= ' rate-fivestar-' . ($i + 1);
        $stars[] = theme('rate_button', array('text' => $links[$i]['text'], 'href' => $links[$i]['href'], 'class' => $class));
    }
    $variables['stars'] = $stars;

    $info = array();
    if ($mode == RATE_CLOSED) {
        $info[] = t('Voting is closed.');
    }
    if ($mode != RATE_COMPACT && $mode != RATE_COMPACT_DISABLED) {
        if (isset($results['user_vote'])) {
            $vote = round($results['user_vote'] / 25) + 1;
            $info[] = t('You voted !vote.', array('!vote' => $vote));
        }
        $info[] = t(';-) Total votes: !count', array('!count' => $results['count']));
    }
    $variables['info'] = implode(' ', $info);
}

