jQuery(document).ready(function($) {

    // alert($(window).height());

    var header = $('#navbar');

    // Touch support
    document.documentElement.className += (("ontouchstart" in document.documentElement) ? ' touch' : ' no-touch');

    // Smooth scroll
    $('a[href^="#"]').on('click', function(event) {
        event.preventDefault();
        // var target = this.hash;
        $('html, body').stop().animate({
            scrollTop : $($(this).attr('href')).offset().top
        }, 1500, 'easeInOutExpo', function() {
            // window.location.hash = target;
        });
    });

    // Toggle Search Block #1
    $('a[href="#block-custom-search-blocks-1"]').click(function(event) {
        event.preventDefault();
        $('#block-custom-search-blocks-1').toggle();
    });

    // Node-Type-Place Map Links
    if ($('body').hasClass('node-type-place')) {
        $('#filters ul li a').each(function(index) {
            if ($(this).data("category") === $('.map-item').data("category")) {
                $(this).addClass('is-checked');
            }
        });
    }

    // MatchMedia
    // Initialize the media query
    var mediaQuery = window.matchMedia('(max-width: 767px)');
    // Add a listen event
    mediaQuery.addListener(mqToggle);
    // Function to do something with the media query
    function mqToggle(mediaQuery) {
        // Header
        if (header.length) {
            if (mediaQuery.matches) {
                header.addClass('navbar-fixed-top');
            } else {
                header.removeClass('navbar-fixed-top');
                if ($('body').hasClass('front')) {
                    var scroll = $(window).scrollTop();
                    var offset = header.offset().top;
                    if (scroll >= offset) {
                        header.addClass('navbar-fixed-top');
                    } else {
                        header.removeClass('navbar-fixed-top');
                    }
                }
            }
        }
        // Activities
        if ($('body').hasClass('page-actividades') || $('body').hasClass('node-type-activity')) {
            if (mediaQuery.matches) {
                $('#toggle-diary').on('click', function(event) {
                    event.preventDefault();
                    swipeL();
                });

                $('#toggle-activities').on('click', function(event) {
                    event.preventDefault();
                    swipeR();
                });

                $('.main-container').swipe({
                    swipeLeft : function(event, direction, distance, duration, fingerCount) {
                        swipeL();
                    },
                    swipeRight : function(event, direction, distance, duration, fingerCount) {
                        swipeR();
                    },
                    threshold : 75 // default
                });
            }
        }
    }

    // On Load
    mqToggle(mediaQuery);

    // On Scroll
    $(window).scroll(function() {
        mqToggle(mediaQuery);
    });

    function swipeL() {
        $('#toggle-activities').removeClass('swiper-right');
        if (!$('#toggle-diary').hasClass('swiper-left')) {
            $('.block-toggle-activities-diary').removeClass('swiped-right').addClass('swiped-left');
            $('.aside-main .region-sidebar-second').show();
            $('.block-system').animate({
                left : '-105%'
            }, 500, function() {
                // Complete
                $(this).hide();
            });
            $('.aside-main .region-sidebar-second').show().animate({
                left : 0
            }, 500, function() {
                // Complete
            });
            $('#toggle-diary').addClass('swiper-left');
        }
    }

    function swipeR() {
        $('#toggle-diary').removeClass('swiper-left');
        if (!$('#toggle-activities').hasClass('swiper-right')) {
            $('.block-toggle-activities-diary').removeClass('swiped-left').addClass('swiped-right');
            $('.block-system').show().animate({
                left : '0'
            }, 500, function() {
                // Complete
            });
            $('.aside-main .region-sidebar-second').animate({
                left : '105%'
            }, 500, function() {
                // Complete
                $(this).hide();
            });
            $('#toggle-activities').addClass('swiper-right');
        }
    }

});

