// Places
var places = [];

// Markers
var markers = [];

// Map
var map;

// InitMap()
function initMap() {

    // Coordinates
    var santiago = new google.maps.LatLng(42.8802351, -8.5622792);

    // Styles
    var styles = [{
        featureType : "all",
        elementType : "geometry",
        stylers : [{
            color : "#ede5e5"
        }, {
            visibility : "on"
        }]
    }, {
        featureType : "road",
        elementType : "geometry",
        stylers : [{
            lightness : 100
        }, {
            visibility : "simplified"
        }]
    }, {
        featureType : "road",
        elementType : "labels",
        stylers : [{
            visibility : "off"
        }]
    }];

    // Map options
    var mapOptions = {
        zoom : 12,
        center : santiago,
        mapTypeControl: false,
        styles : styles
    };

    // Map
    map = new google.maps.Map(document.getElementById("map"), mapOptions);

    // Items
    var items = document.querySelectorAll(".map-item");

    // Item
    for (var i = 0; i < items.length; i++) {
        var item = items[i];
        // Places
        var id = item.dataset.id;
        var name = item.dataset.name;
        var latitude = parseFloat(item.dataset.latitude);
        var longitude = parseFloat(item.dataset.longitude);
        var category = item.dataset.category.toLowerCase();
        var place = [id, name, latitude, longitude, category];
        places.push(place);
        // Info Window
        var infowindow = new google.maps.InfoWindow({
            content : name
        });

        // Markers
        var marker = new google.maps.Marker({
            position : {
                lat : latitude,
                lng : longitude
            },
            map : map,
            category : category,
            id : id,
            // title: name,
            name : name,
            icon : 'http://maps.google.com/mapfiles/ms/micons/purple.png',
            animation : google.maps.Animation.DROP,
            infowindow : infowindow
        });
        // marker.category = category;
        markers.push(marker);
        // marker.addListener('click', toggleBounce);
        marker.addListener('click', function() {
            this.infowindow.open(map, this);
        })
    }
    // console.table(places);
    // console.table(markers);

    // Buttons by Category
    var buttonShow = document.getElementById("show-all");
    if (buttonShow !== null) {
        buttonShow.addEventListener("click", function(event) {
            showAllMarkers(map);
        });
    }

    // Buttons by Category
    /*
    var buttons = document.querySelectorAll(".toggle-category");
    for (var i = 0; i < buttons.length; i++) {
    var button = buttons[i];
    button.addEventListener("click", function(event) {
    toggleMarkersByCategory(this.dataset.category);
    });
    }
    */

    // Links by Id
    var links = document.querySelectorAll(".map-item-link");
    for (var i = 0; i < links.length; i++) {
        var link = links[i];
        link.addEventListener("click", function(event) {
            toggleMarkersById(this.dataset.id);
        });
    }

    // Check hash on init
    onHashChange();

}

// Check markers on Hash Change
window.onhashchange = onHashChange;

// Sets the map on all markers in the array.
function showAllMarkers(map) {
    for (var i = 0; i < markers.length; i++) {
        var marker = markers[i];
        marker.setMap(map);
        marker.infowindow.close();
    }
}

// ToggleMarkers(byCategory)
/*
function toggleMarkersByCategory(category) {
for (var i = 0; i < markers.length; i++) {
var marker = markers[i];
if (marker.category === category) {
marker.setMap(map);
marker.infowindow.close();
} else {
marker.setMap(null);
}
}
}
*/

// ToggleMarkers(byHash)
function toggleMarkersByHash(hash) {
    for (var i = 0; i < markers.length; i++) {
        var marker = markers[i];
        if (hash === 'todos') {
            showAllMarkers(map);
        } else if (hash === marker.category) {
            marker.setMap(map);
            marker.infowindow.close();
        } else {
            marker.setMap(null);
        }
    }
}

// ToggleMarkers(byId)
function toggleMarkersById(id) {
    for (var i = 0; i < markers.length; i++) {
        var marker = markers[i];
        if (marker.id === id) {
            if (marker.infowindow) {
                marker.infowindow.close();
            }
            marker.infowindow.open(map, marker);
            marker.setAnimation(google.maps.Animation.BOUNCE);
            stopAnimation(marker);
            marker.setMap(map);
        } else {
            marker.setMap(null);
        }
    }
}

// StopAnimation(marker)
function stopAnimation(marker) {
    setTimeout(function() {
        marker.setAnimation(null);
    }, 2100);
}

// onHashChange
function onHashChange() {
    // Filter by hash
    var hash = location.hash.match(/^#?(.*)$/)[1];
    if (hash) {
        // console.log(hash);
        toggleMarkersByHash(hash);
    }
}

