jQuery(document).ready(function($) {

    // Init Isotope
    var $grid = $('.grid').isotope({
        itemSelector : '.map-item',
        layoutMode : 'fitRows'
    });

    // Bind filter button click
    $('#filters').on('click', 'a', function() {
        var filterValue = $(this).attr('data-filter');
        $grid.isotope({
            filter : filterValue
        });
    });

    // Change is-checked class on buttons
    $('.button-group').each(function(i, buttonGroup) {
        var $buttonGroup = $(buttonGroup);
        $buttonGroup.on('click', 'a', function() {
            $buttonGroup.find('.is-checked').removeClass('is-checked');
            $(this).addClass('is-checked');
            var cat = $(this).attr('data-category');
            // console.log(cat);
            if (cat !== undefined) {
                location.hash = '' + encodeURIComponent(cat);
            }
        });
    });

    function onHashChange() {
        // Filter by hash
        var hash = location.hash.match(/^#?(.*)$/)[1];
        if (hash) {
            // console.log(hash);
            $('.button-group a[data-category=' + hash + ']').click();
        } else {
            $('#show-all').click();
        }
    }


    $(window).load(function() {
        $('.grid').isotope('layout');
    });

    $(window).on('hashchange', onHashChange);
    // Trigger event handler to init Isotope
    onHashChange();

});

