<?php
/**
 * @file
 * Theme setting callbacks for the denma theme.
 */

/**
 * Implements hook_form_FORM_ID_alter().
 */
function denma_form_system_theme_settings_alter(&$form, &$form_state) {


  $form['denma_settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('denma Theme Settings'),
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );
    $form['denma_settings']['secondary_logo'] = array(
    '#title' => t('Secondary logo'),
    '#description' => t('A description'),
    '#type' => 'managed_file',
    '#upload_location' => 'public://secondary-logo/',
    '#upload_validators' => array(
      'file_validate_extensions' => array('gif png jpg jpeg'),
    ),
    '#default_value' => theme_get_setting('secondary_logo', 'denma'),
  );
  $form['denma_settings']['breadcrumbs'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show breadcrumbs in a page'),
    '#default_value' => theme_get_setting('breadcrumbs', 'denma'),
    '#description'   => t("Check this option to show breadcrumbs in page. Uncheck to hide."),
  );
  $form['denma_settings']['slideshow'] = array(
    '#type' => 'fieldset',
    '#title' => t('Front Page Slideshow'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['denma_settings']['slideshow']['slideshow_display'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show slideshow'),
    '#default_value' => theme_get_setting('slideshow_display', 'denma'),
    '#description'   => t("Check this option to show Slideshow in front page. Uncheck to hide."),
  );
  $form['denma_settings']['slideshow']['slide'] = array(
    '#markup' => t('You can change the description of each slide in the following Slide Settings.'),
  );
  $form['denma_settings']['slideshow']['slide1'] = array(
    '#type' => 'fieldset',
    '#title' => t('Slide 1'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form['denma_settings']['slideshow']['slide1']['slide1_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Slide Title'),
    '#default_value' => theme_get_setting('slide1_title', 'denma'),
  );
  $form['denma_settings']['slideshow']['slide1']['slide1_desc'] = array(
    '#type' => 'textfield',
    '#title' => t('Slide Description'),
    '#default_value' => theme_get_setting('slide1_desc', 'denma'),
  );
  $form['denma_settings']['slideshow']['slide2'] = array(
    '#type' => 'fieldset',
    '#title' => t('Slide 2'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form['denma_settings']['slideshow']['slide2']['slide2_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Slide Title'),
    '#default_value' => theme_get_setting('slide2_title', 'denma'),
  );
  $form['denma_settings']['slideshow']['slide2']['slide2_desc'] = array(
    '#type' => 'textfield',
    '#title' => t('Slide Description'),
    '#default_value' => theme_get_setting('slide2_desc', 'denma'),
  );
  $form['denma_settings']['slideshow']['slide3'] = array(
    '#type' => 'fieldset',
    '#title' => t('Slide 3'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form['denma_settings']['slideshow']['slide3']['slide3_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Slide Title'),
    '#default_value' => theme_get_setting('slide3_title', 'denma'),
  );
  $form['denma_settings']['slideshow']['slide3']['slide3_desc'] = array(
    '#type' => 'textfield',
    '#title' => t('Slide Description'),
    '#default_value' => theme_get_setting('slide3_desc', 'denma'),
  );
  $form['denma_settings']['slideshow']['slideimage'] = array(
    '#markup' => t('To change the Slide Images, Replace the slide-image-1.jpg, slide-image-2.jpg and slide-image-3.jpg in the images folder of the denma theme folder.'),
  );
  $form['denma_settings']['social'] = array(
    '#type' => 'fieldset',
    '#title' => t('Social Icon'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['denma_settings']['social']['display'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show Social Icon'),
    '#default_value' => theme_get_setting('display', 'denma'),
    '#description'   => t("Check this option to show Social Icon. Uncheck to hide."),
  );
  $form['denma_settings']['social']['twitter'] = array(
    '#type' => 'textfield',
    '#title' => t('Twitter URL'),
    '#default_value' => theme_get_setting('twitter', 'denma'),
    '#description' => t("Enter your Twitter Profile URL. example:: http://www.xyz.com"),
  );
  $form['denma_settings']['social']['facebook'] = array(
    '#type' => 'textfield',
    '#title' => t('Facebook URL'),
    '#default_value' => theme_get_setting('facebook', 'denma'),
    '#description'   => t("Enter your Facebook Profile URL. example:: http://www.xyz.com"),
  );
  $form['denma_settings']['social']['linkedin'] = array(
    '#type' => 'textfield',
    '#title' => t('LinkedIn URL'),
    '#default_value' => theme_get_setting('linkedin', 'denma'),
    '#description'   => t("Enter your LinkedIn Profile URL. example:: http://www.xyz.com"),
  );
  $form['denma_settings']['Welcome'] = array(
    '#type' => 'fieldset',
    '#title' => t('Welcome Text'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['denma_settings']['Welcome']['welcome_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Add Title'),
    '#default_value' => theme_get_setting('welcome_title', 'denma'),
    '#description'   => t("Enter Title for Welcome text at frontpage."),
  );
  $form['denma_settings']['Welcome']['welcome_text'] = array(
    '#type' => 'textarea',
    '#title' => t('Add Description'),
    '#default_value' => theme_get_setting('welcome_text', 'denma'),
    '#description'   => t("Enter Description for Welcome text at frontpage."),
  );
  $form['denma_settings']['Columns'] = array(
    '#type' => 'fieldset',
    '#title' => t('Columns'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['denma_settings']['Columns']['columns_markup'] = array(
    '#markup' => t('Default Promoted Area Images are placed at <b>denma/images/promoted</b>, User will able to change these images path or image name from column\'s description settings.</br><code>Example : &lt;img src="sites/all/themes/denma/images/promoted/col1.jpg"&gt;</code></br><b>Image Dimensions :</b></br>For 1 Column = Max Width will be 960px</br>For 2 Column = Max Width will be 467px</br>For 3 Column = Max Width will be 306px</br></br>To keep image on top of the conent use below pattern,<code>&lt;div class="image_wrapper"&gt;&lt;img src="sites/all/themes/denma/images/promoted/col1.jpg"&gt;&lt;/div&gt;"</code>If IMG is not inside the DIV mentioned above, image and content will be inline.'),
  );
  $form['denma_settings']['Columns']['customtext'] = array(
    '#type' => 'textarea',
    '#title' => t('Custom Text'),
    '#default_value' => theme_get_setting('customtext', 'denma'),
    '#description'   => t("Enter Custom Text."),
  );
  $form['denma_settings']['Columns']['colonetitle'] = array(
    '#type' => 'textfield',
    '#title' => t('First Column Title'),
    '#default_value' => theme_get_setting('colonetitle', 'denma'),
    '#description'   => t("Enter Title for First Column."),
  );
  $form['denma_settings']['Columns']['colone'] = array(
    '#type' => 'textarea',
    '#title' => t('First Column Description'),
    '#default_value' => theme_get_setting('colone', 'denma'),
    '#description'   => t("Enter Description for First Column."),
  );
  $form['denma_settings']['Columns']['coltwotitle'] = array(
    '#type' => 'textfield',
    '#title' => t('Second Column Title'),
    '#default_value' => theme_get_setting('coltwotitle', 'denma'),
    '#description'   => t("Enter Title for Second Column."),
  );
  $form['denma_settings']['Columns']['coltwo'] = array(
    '#type' => 'textarea',
    '#title' => t('Second Column Description'),
    '#default_value' => theme_get_setting('coltwo', 'denma'),
    '#description'   => t("Enter Description for Second Column."),
  );
  $form['denma_settings']['Columns']['colthreetitle'] = array(
    '#type' => 'textfield',
    '#title' => t('Third Column Title'),
    '#default_value' => theme_get_setting('colthreetitle', 'denma'),
    '#description'   => t("Enter Title for Third Column."),
  );
  $form['denma_settings']['Columns']['colthree'] = array(
    '#type' => 'textarea',
    '#title' => t('Third Column Description'),
    '#default_value' => theme_get_setting('colthree', 'denma'),
    '#description'   => t("Enter Description for Third Column."),
  );
  $form['denma_settings']['footer'] = array(
    '#type' => 'fieldset',
    '#title' => t('Footer'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );
  $form['denma_settings']['footer']['footer_copyright'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show copyright text in footer'),
    '#default_value' => theme_get_setting('footer_copyright', 'denma'),
    '#description'   => t("Check this option to show copyright text in footer. Uncheck to hide."),
  );
  $form['denma_settings']['footer']['footer_developed'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show theme developed by in footer'),
    '#default_value' => theme_get_setting('footer_developed', 'denma'),
    '#description'   => t("Check this option to show design & developed by text in footer. Uncheck to hide."),
  );
  $form['denma_settings']['footer']['footer_developedby'] = array(
    '#type' => 'textfield',
    '#title' => t('Add name developed by in footer'),
    '#default_value' => theme_get_setting('footer_developedby', 'denma'),
    '#description'   => t("Add name developed by in footer"),
  );
  $form['denma_settings']['footer']['footer_developedby_url'] = array(
    '#type' => 'textfield',
    '#title' => t('Add link to developed by in footer'),
    '#default_value' => theme_get_setting('footer_developedby_url', 'denma'),
    '#description'   => t("Add url developed by in footer. example:: http://www.xyz.com"),
  );

}
