<?php
/**
 * @file
 * Contains theme override functions and preprocess functions for the theme.
 */

/**
 * Implements hook_html_head_alter().
 */
function denma_html_head_alter(&$head_elements) {
  $head_elements['system_meta_content_type']['#attributes'] = array(
    'charset' => 'utf-8',
  );
}

/**
 * Insert themed breadcrumb page navigation at top of the node content.
 */
function denma_breadcrumb($variables) {
  $breadcrumb = $variables['breadcrumb'];
  if (!empty($breadcrumb)) {
    // Use CSS to hide titile .element-invisible.
    $output = '<h2 class="element-invisible">' . t('You are here') . '</h2>';
    // Comment below line to hide current page to breadcrumb.
    $breadcrumb[] = drupal_get_title();
    $output .= '<div class="breadcrumb">' . implode(' » ', $breadcrumb) . '</div>';
    return $output;
  }
}

/**
 * Add javascript files for front-page jquery slideshow.
 */
if (drupal_is_front_page()) {
  drupal_add_js(drupal_get_path('theme', 'denma') . '/js/slider.js');
}

/**
 * Add Google Fonts.
 */
function denma_preprocess_html(&$variables) {
  drupal_add_css('http://fonts.googleapis.com/css?family=Open+Sans', array('type' => 'external'));
  drupal_add_css('http://fonts.googleapis.com/css?family=Montserrat', array('type' => 'external'));
}

function denma_filter($string) {
	$filters = array('a', 'abbr', 'acronym', 'address', 'article', 'aside', 'b', 'bdi', 'bdo', 'big', 'blockquote', 'br', 'button', 'input', 'caption', 'cite', 'code', 'col', 'colgroup', 'command', 'dd', 'del', 'details', 'dfn', 'div', 'dl', 'dt', 'em', 'figcaption', 'figure', 'form', 'footer', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr', 'i', 'iframe', 'img', 'ins', 'kbd', 'label', 'li', 'mark', 'menu', 'meter', 'nav', 'ol', 'output', 'p', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'section', 'small', 'span', 'strong', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'tt', 'u', 'ul', 'var', 'wbr');
  return filter_xss($string, $filters);
}

/**
 * Override or insert variables into the page template.
 */
function denma_preprocess_page(&$vars, $hook) {
  $vars['twitter'] = theme_get_setting('twitter', 'denma');
  $vars['facebook'] = theme_get_setting('facebook', 'denma');
  $vars['linkedin'] = theme_get_setting('linkedin', 'denma');
  $vars['theme_path_social'] = base_path() . drupal_get_path('theme', 'denma');
  $vars['display'] = theme_get_setting('display', 'denma');
  $vars['footer_copyright'] = theme_get_setting('footer_copyright');
  $vars['footer_developed'] = theme_get_setting('footer_developed');
  $vars['footer_developedby_url'] = denma_filter(theme_get_setting('footer_developedby_url', 'denma'));
  $vars['footer_developedby'] = denma_filter(theme_get_setting('footer_developedby', 'denma'));
  $vars['searchblock'] = module_invoke('search', 'block_view', 'form');
  if (module_exists('i18n_menu')) {
    $vars['main_menu_tree'] = i18n_menu_translated_tree(variable_get('menu_main_links_source', 'main-menu'));
  }
  else {
    $vars['main_menu_tree'] = menu_tree(variable_get('menu_main_links_source', 'main-menu'));
  }
  if (isset($vars['node'])) {
    
    $vars['theme_hook_suggestions'][] = 'page__'. $vars['node']->type;
  }
  // Frontpage variables.
  $vars['slideshow_display'] = theme_get_setting('slideshow_display', 'denma');
  $vars['slide1_title'] = theme_get_setting('slide1_title', 'denma');
  $vars['slide2_title'] = theme_get_setting('slide2_title', 'denma');
  $vars['slide3_title'] = theme_get_setting('slide3_title', 'denma');
  $vars['slide1_desc'] = theme_get_setting('slide1_desc', 'denma');
  $vars['slide2_desc'] = theme_get_setting('slide2_desc', 'denma');
  $vars['slide3_desc'] = theme_get_setting('slide3_desc', 'denma');

  $vars['secondary_logo'] = theme_get_setting('secondary_logo', 'denma');

  $vars['wtitle'] = denma_filter(theme_get_setting('welcome_title', 'denma'));
  $vars['wtext'] = denma_filter(theme_get_setting('welcome_text', 'denma'));
  $vars['customtext'] = denma_filter(theme_get_setting('customtext', 'denma'));
  $vars['col1'] = denma_filter(theme_get_setting('colone', 'denma'));
  $vars['col1title'] = denma_filter(theme_get_setting('colonetitle', 'denma'));
  $vars['col2'] = denma_filter(theme_get_setting('coltwo', 'denma'));
  $vars['col2title'] = denma_filter(theme_get_setting('coltwotitle', 'denma'));
  $vars['col3'] = denma_filter(theme_get_setting('colthree', 'denma'));
  $vars['col3title'] = denma_filter(theme_get_setting('colthreetitle', 'denma'));
  $vars['img1'] = base_path() . drupal_get_path('theme', 'denma') . '/images/slideshow/slide-image-1.jpg';
  $vars['img2'] = base_path() . drupal_get_path('theme', 'denma') . '/images/slideshow/slide-image-2.jpg';
  $vars['img3'] = base_path() . drupal_get_path('theme', 'denma') . '/images/slideshow/slide-image-3.jpg';  
  $image1var = array(
    'path' => $vars['img1'],
    'alt' => $vars['slide1_title'],
    'title' => $vars['slide1_title'],
    'attributes' => array('class' => 'slide-img'),
  );
  $vars['slideimage1'] = theme('image', $image1var);
  $image2var = array(
    'path' => $vars['img2'],
    'alt' => $vars['slide2_title'],
    'title' => $vars['slide2_title'],
    'attributes' => array('class' => 'slide-img'),
  );
  $vars['slideimage2'] = theme('image', $image2var);
  $image3var = array(
    'path' => $vars['img3'],
    'alt' => $vars['slide3_title'],
    'title' => $vars['slide3_title'],
    'attributes' => array('class' => 'slide-img'),
  );
  $vars['slideimage3'] = theme('image', $image3var);
}
